/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * THIS FILE IS AUTOGENERATED by cddlconv 0.1.7.
 * Run `node tools/generate-bidi-types.mjs` to regenerate.
 * @see https://github.com/w3c/webdriver-bidi/blob/master/index.bs
 */
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-nocheck Some types may be circular.
import z from 'zod';
export const UserAgentClientHintsCommandSchema = z.lazy(() => Emulation.SetClientHintsOverrideCommandSchema);
export var Emulation;
(function (Emulation) {
    Emulation.SetClientHintsOverrideCommandSchema = z.lazy(() => z.object({
        method: z.literal('emulation.setClientHintsOverride'),
        params: z.object({
            clientHints: z.union([Emulation.ClientHintsMetadataSchema, z.null()]),
            contexts: z.array(z.string()).min(1).optional(),
            userContexts: z.array(z.string()).min(1).optional(),
        }),
    }));
})(Emulation || (Emulation = {}));
(function (Emulation) {
    Emulation.ClientHintsMetadataSchema = z.lazy(() => z.object({
        brands: z.array(Emulation.BrandVersionSchema).optional(),
        fullVersionList: z.array(Emulation.BrandVersionSchema).optional(),
        platform: z.string().optional(),
        platformVersion: z.string().optional(),
        architecture: z.string().optional(),
        model: z.string().optional(),
        mobile: z.boolean().optional(),
        bitness: z.string().optional(),
        wow64: z.boolean().optional(),
        formFactors: z.array(z.string()).optional(),
    }));
})(Emulation || (Emulation = {}));
(function (Emulation) {
    Emulation.BrandVersionSchema = z.lazy(() => z.object({
        brand: z.string(),
        version: z.string(),
    }));
})(Emulation || (Emulation = {}));
(function (Emulation) {
    Emulation.SetClientHintsOverrideResultSchema = z.lazy(() => z.object({}));
})(Emulation || (Emulation = {}));
//# sourceMappingURL=webdriver-bidi-ua-client-hints.js.map