<?php
/**
 * Entrega o PDF gerado e limpa o arquivo do servidor
 */
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: *");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') exit(0);

$fileId = $_GET['fileId'] ?? '';
if (!$fileId || !preg_match('/^[a-zA-Z0-9_]+$/', $fileId)) {
    die('Invalid ID');
}

$tmpDir = __DIR__ . '/tmp_gen';
$pdfFile = "$tmpDir/{$fileId}.pdf";
$htmlFile = "$tmpDir/{$fileId}.html";

if (file_exists($pdfFile)) {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="Catalogo_Covel.pdf"');
    header('Content-Length: ' . filesize($pdfFile));
    readfile($pdfFile);
    // Unlink removido para garantir que o cliente consiga baixar mesmo com instabilidade
} else {
    http_response_code(404);
    echo "Arquivo não encontrado.";
}
