const puppeteer = require('puppeteer');
const fs = require('fs');
const path = require('path');

(async () => {
    // Args: node render_pdf.js <input_html_path> <output_pdf_path>
    const inputPath = process.argv[2];
    const outputPath = process.argv[3];

    if (!inputPath || !outputPath) {
        console.error('Usage: node render_pdf.js <input.html> <output.pdf>');
        process.exit(1);
    }

    // Resolve full path for file protocol
    const htmlUrl = 'file://' + path.resolve(inputPath);

    try {
        const browser = await puppeteer.launch({
            headless: 'new',
            args: ['--no-sandbox', '--disable-setuid-sandbox'] // Necessário para rodar em alguns ambientes Docker/Linux
        });

        const page = await browser.newPage();

        // Viewport não afeta o PDF, mas ajuda na renderização de layouts responsivos
        await page.setViewport({ width: 1240, height: 1754, deviceScaleFactor: 2 });

        await page.goto(htmlUrl, {
            waitUntil: 'networkidle0', // Espera carregar todas as imagens/fonts
            timeout: 60000
        });

        await page.pdf({
            path: outputPath,
            format: 'A4',
            printBackground: true, // FUNDAMENTAL para bg-colors e gradients
            margin: {
                top: '0px',
                right: '0px',
                bottom: '0px',
                left: '0px'
            }
        });

        await browser.close();
        console.log(`PDF saved to ${outputPath}`);

    } catch (error) {
        console.error('Puppeteer Error:', error);
        process.exit(1);
    }
})();
