<?php
/**
 * Covel Veículos - LP Generator v5 (Custom Template)
 * Based on catalogo_veiculos.html provided by user
 */

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'debug.log');
error_reporting(E_ALL);

// DEBUG LOG
file_put_contents('debug_requests.log', date('Y-m-d H:i:s') . " - NEW REQUEST [" . $_SERVER['REQUEST_METHOD'] . "] from " . $_SERVER['REMOTE_ADDR'] . "\n", FILE_APPEND);

// CORS TOTAL BLINDADO
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit(0);
}

// Aumentar limites para Puppeteer (Crucial para arquivos grandes)
set_time_limit(300); // 5 minutos
ini_set('memory_limit', '512M');

require 'ai_service.php';

try {
// Input
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

if (!$input || !isset($input['id'])) {
    http_response_code(400);
    die('Vehicle ID required');
}

$vehicleId = $input['id'];

// Fetch XML
$xmlUrl = 'https://app.revendamais.com.br/application/index.php/apiGeneratorXml/generator/sitedaloja/5358d2c5b178fd7a21b077dcd41fa3f65199.xml';
$context = stream_context_create(["http" => ["header" => "User-Agent: CovelPDF/LP"]]);
libxml_set_streams_context($context);
$xmlContent = @file_get_contents($xmlUrl);

if (!$xmlContent) {
    sleep(1);
    $xmlContent = @file_get_contents($xmlUrl);
    if (!$xmlContent) die('XML failed to load');
}

$xml = simplexml_load_string($xmlContent, 'SimpleXMLElement', LIBXML_NOCDATA);
if (!$xml) die('XML parse failed');

// Find Vehicle
$vehicle = null;
foreach ($xml->AD as $ad) {
    if (trim((string)$ad->ID) === trim($vehicleId)) {
        $vehicle = $ad;
        break;
    }
}
if (!$vehicle) die('Not found');

// Images
$images = [];
if (isset($vehicle->IMAGES_LARGE->IMAGE_URL_LARGE)) {
    foreach($vehicle->IMAGES_LARGE->IMAGE_URL_LARGE as $img) $images[] = (string)$img;
} elseif (isset($vehicle->IMAGES->IMAGE_URL)) {
    foreach($vehicle->IMAGES->IMAGE_URL as $img) $images[] = (string)$img;
}
$img1 = $images[0] ?? 'https://via.placeholder.com/800x600/ccc/333?text=Cover';

// Vehicle Data Map
$v = [
    'make' => (string)$vehicle->MAKE,
    'model' => (string)$vehicle->MODEL,
    'version' => (string)$vehicle->VERSION,
    'price' => 'R$ ' . number_format((float)$vehicle->PRICE, 2, ',', '.'),
    'price_raw' => (float)$vehicle->PRICE,
    'year_fab' => (string)$vehicle->FABRIC_YEAR,
    'year_mod' => (string)$vehicle->YEAR,
    'km' => number_format((float)$vehicle->MILEAGE, 0, ',', '.') . ' km',
    'fuel' => (string)$vehicle->FUEL,
    'gear' => (string)$vehicle->GEAR,
    'color' => (string)$vehicle->COLOR,
    'doors' => (string)$vehicle->DOORS,
    'plate' => substr((string)$vehicle->PLATE, -1),
    'plate_full' => (string)$vehicle->PLATE,
    'accessories' => (string)$vehicle->ACCESSORIES,
    'description' => (string)$vehicle->DESCRIPTION,
    'user_name' => $input['user_name'] ?? 'Cliente VIP'
];

// FIPE (simulado ou extraído se houver, aqui vou colocar placeholder calculado)
$fipeVal = $v['price_raw'] * 0.95; // Simulação: Fipe um pouco abaixo da venda
$v['fipe'] = 'R$ ' . number_format($fipeVal, 0, ',', '.'); // Sem centavos

// AI Content
$ai = AIService::generateStrictCatalogContent($v);

// Prepare Highlights List (from AI or Fallback)
$highlightsList = '';
if (!empty($ai['highlights_list'])) {
    foreach (array_slice($ai['highlights_list'], 0, 8) as $h) {
        $highlightsList .= "<li>$h</li>";
    }
} else {
    // Fallback highlights from description/accessories
    $accs = explode(',', $v['accessories']);
    foreach(array_slice($accs, 0, 8) as $h) {
        $highlightsList .= "<li>".trim($h)."</li>";
    }
}

// Prepare Gallery Pages
$galleryHtml = '';
$galleryImages = array_slice($images, 1);
$chunks = array_chunk($galleryImages, 2);

foreach ($chunks as $chunk) {
    // Reutilizando estrutura da .vehicle-page mas adaptada para galeria
    $galleryHtml .= '<div class="vehicle-page">';
    $galleryHtml .= '
      <div class="vp__header">
        <div class="vp__header-brand">Covel Veículos — Galeria</div>
        <div class="vp__header-id">#'.$vehicleId.'</div>
      </div>';
      
    // Images Container
    $galleryHtml .= '<div style="position:absolute; top:80px; left:0; right:0; bottom:60px; padding:0 36px; display:flex; flex-direction:column; gap:20px;">';
    
    foreach ($chunk as $img) {
         $galleryHtml .= '<div style="flex:1; width:100%; border-radius:4px; overflow:hidden; background:#000;">
            <img src="'.$img.'" style="width:100%; height:100%; object-fit:cover;" />
         </div>';
    }
    
    $galleryHtml .= '</div>';
    
    // Contact Footer
    $galleryHtml .= '
      <div class="vp__contact">
        <div class="vp__contact-item">
          <div class="vp__contact-dot"></div>
          <span class="vp__contact-text">(51) 3751-1234</span>
        </div>
        <div class="vp__contact-item">
          <div class="vp__contact-dot"></div>
          <span class="vp__contact-text">Rua Júlio de Castilhos, 1795 – Encantado / RS</span>
        </div>
        <div class="vp__contact-item">
          <div class="vp__contact-dot"></div>
          <span class="vp__contact-text">covelveiculos.com.br</span>
        </div>
      </div>';
      
    $galleryHtml .= '</div>'; // End Page
}


// Full HTML Construction
$yearDisplay = $v['year_mod'] . ' (fab. ' . $v['year_fab'] . ')';
$titleLine = $v['model']; // Territory
$trimLine = $v['version'] . ' · ' . $v['gear']; // Titanium · Automático
$userName = $v['user_name']; // Nome do cliente para o PDF

// CSS Inlined from the template provided
$css = <<<CSS
  /* ─── RESET & BASE ─── */
  *, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }
  @page { size: A4 portrait; margin: 0; }
  :root {
    --ink:        #0a0a0a;
    --smoke:      #1a1a1f;
    --ash:        #2a2a33;
    --mid:        #4a4a55;
    --fog:        #7a7a88;
    --ghost:      #b8b8c4;
    --paper:      #f4f3f0;
    --cream:      #ede9df;
    --accent:     #d4a843;
    --accent-lt:  #e8c96a;
    --accent-dk:  #a07d2a;
  }
  html, body {
    width: 210mm; margin: 0 auto; background: var(--paper); color: var(--ink);
    font-family: 'Georgia', 'Times New Roman', serif;
  }
  .cover { width: 210mm; height: 297mm; position: relative; overflow: hidden; background: var(--ink); page-break-after: always; }
  .cover::before { content: ''; position: absolute; inset: 0; background: linear-gradient(145deg, #000 0%, #12121a 40%, #1e1e2a 70%, #0a0a0a 100%); z-index: 1; }
  .cover__stripe { position: absolute; top: -60px; left: -80px; width: 160%; height: 3px; background: linear-gradient(90deg, transparent 0%, var(--accent) 30%, var(--accent-lt) 50%, var(--accent) 70%, transparent 100%); transform: rotate(25deg); transform-origin: left center; top: 38%; z-index: 2; opacity: .7; }
  .cover__stripe--2 { top: 40%; opacity: .3; height: 1px; }
  .cover__stripe--3 { top: 42%; opacity: .15; height: 1px; }
  .cover__circle { position: absolute; width: 380px; height: 380px; border-radius: 50%; border: 1px solid rgba(212,168,67,.12); right: -100px; top: 50%; transform: translateY(-50%); z-index: 2; }
  .cover__circle--2 { width: 300px; height: 300px; border-color: rgba(212,168,67,.08); right: -60px; }
  .cover__circle--3 { width: 220px; height: 220px; border-color: rgba(212,168,67,.05); right: -20px; }
  .cover__poly { position: absolute; bottom: 0; left: 0; width: 0; height: 0; border-style: solid; border-width: 180px 260px 0 0; border-color: transparent rgba(212,168,67,.06) transparent transparent; z-index: 2; }
  .cover__content { position: relative; z-index: 5; height: 100%; display: flex; flex-direction: column; justify-content: flex-end; padding: 60px 52px; }
  .cover__logo-area { position: absolute; top: 52px; left: 52px; display: flex; align-items: center; gap: 16px; }
  .cover__logo-badge { width: 56px; height: 56px; border-radius: 12px; background: linear-gradient(135deg, var(--accent), var(--accent-dk)); display: flex; align-items: center; justify-content: center; font-size: 22px; font-weight: 700; color: #fff; font-family: 'Arial', sans-serif; letter-spacing: -1px; }
  .cover__logo-text { color: #fff; font-family: 'Georgia', serif; font-size: 18px; letter-spacing: 3px; text-transform: uppercase; opacity: .9; }
  .cover__logo-sub { color: var(--accent); font-size: 10px; letter-spacing: 4px; text-transform: uppercase; margin-top: 2px; }
  .cover__year-tag { position: absolute; top: 52px; right: 52px; background: linear-gradient(135deg, var(--accent), var(--accent-dk)); color: #fff; font-family: 'Georgia', serif; font-size: 11px; letter-spacing: 3px; text-transform: uppercase; padding: 8px 18px; border-radius: 30px; }
  .cover__title { color: #fff; font-size: 58px; line-height: 1.05; font-weight: 400; letter-spacing: -1px; margin-bottom: 12px; }
  .cover__title em { font-style: italic; color: var(--accent); }
  .cover__divider { width: 64px; height: 2px; background: linear-gradient(90deg, var(--accent), transparent); margin-bottom: 18px; }
  .cover__subtitle { color: var(--fog); font-size: 14px; letter-spacing: 1.5px; line-height: 1.7; max-width: 380px; }
  .cover__footer { position: absolute; bottom: 38px; right: 52px; text-align: right; }
  .cover__footer-line { color: var(--mid); font-size: 9px; letter-spacing: 2px; text-transform: uppercase; }

  /* PAGE 2+ */
  .vehicle-page { width: 210mm; height: 297mm; position: relative; overflow: hidden; background: var(--paper); page-break-after: always; page-break-inside: avoid; }
  .vp__header { position: absolute; top: 0; left: 0; right: 0; height: 68px; background: var(--smoke); z-index: 10; display: flex; align-items: center; justify-content: space-between; padding: 0 36px; }
  .vp__header-brand { color: #fff; font-size: 11px; letter-spacing: 3px; text-transform: uppercase; display: flex; align-items: center; gap: 10px; }
  .vp__header-brand::before { content: ''; display: inline-block; width: 20px; height: 2px; background: var(--accent); }
  .vp__header-id { color: var(--fog); font-size: 9px; letter-spacing: 2px; }
  .vp__hero { position: absolute; top: 68px; left: 0; right: 0; height: 260px; background: var(--smoke); overflow: hidden; }
  /* FIX: Object-fit workaround for DomPDF */
  .vp__hero-img { width: 100%; min-height: 100%; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); }

  .vp__owner-badge { position: absolute; top: 82px; left: 36px; z-index: 6; background: linear-gradient(135deg, var(--accent), var(--accent-dk)); color: #fff; border-radius: 6px; padding: 5px 11px; font-size: 8.5px; letter-spacing: 1.5px; text-transform: uppercase; box-shadow: 0 2px 8px rgba(0,0,0,.18); }
  .vp__plate { position: absolute; top: 82px; right: 36px; z-index: 6; background: rgba(255,255,255,.92); border-radius: 6px; padding: 5px 11px; font-size: 11px; font-family: 'Arial', sans-serif; font-weight: 700; color: var(--ink); letter-spacing: 2px; text-transform: uppercase; border: 1px solid rgba(0,0,0,.08); box-shadow: 0 2px 8px rgba(0,0,0,.12); }
  .vp__accent-bar { position: absolute; top: 318px; left: 36px; right: 36px; height: 2px; background: linear-gradient(90deg, var(--accent), var(--accent-lt) 50%, var(--accent)); z-index: 5; }
  .vp__body { position: absolute; top: 330px; left: 0; right: 0; bottom: 0; padding: 18px 36px 30px; display: table; width: 90%; }  /* Changed to Table */
  .vp__left { display: table-cell; width: 65%; padding-right: 20px; vertical-align: top; }
  .vp__right { display: table-cell; width: 35%; vertical-align: top; text-align: right; }

  .vp__make { font-size: 10px; letter-spacing: 4px; text-transform: uppercase; color: var(--accent); margin-bottom: 4px; }
  .vp__model { font-size: 28px; color: var(--ink); line-height: 1.15; font-weight: 400; letter-spacing: -.5px; }
  .vp__trim { font-size: 13px; color: var(--fog); margin-top: 4px; letter-spacing: .5px; }
  .vp__year-badge { display: inline-block; margin-top: 10px; background: linear-gradient(135deg, var(--accent), var(--accent-dk)); color: #fff; font-size: 11px; letter-spacing: 2px; padding: 4px 12px; border-radius: 20px; width: fit-content; }

  /* Grid simulation with tables */
  .vp__specs-table { width: 100%; margin-top: 20px; border-collapse: separate; border-spacing: 0 10px; }
  .vp__specs-table td { vertical-align: top; padding-right: 15px; width: 50%; }

  .vp__spec-label { font-size: 8px; letter-spacing: 2px; text-transform: uppercase; color: var(--fog); display: block; }
  .vp__spec-value { font-size: 13px; color: var(--ink); font-family: 'Georgia', serif; font-weight: bold; }

  .vp__price-box { background: var(--smoke); border-radius: 14px; padding: 18px 20px; width: 100%; position: relative; overflow: hidden; margin-bottom: 20px; }
  .vp__price { color: #fff; font-size: 26px; letter-spacing: -.5px; }
  .vp__price span { font-size: 14px; color: var(--accent); }
  .vp__price-label { color: var(--fog); font-size: 8px; letter-spacing: 2.5px; text-transform: uppercase; margin-bottom: 6px; }
  .vp__price-fipe { color: var(--mid); font-size: 9px; margin-top: 6px; }

  .vp__highlights { margin-top: 16px; width: 100%; list-style: none; text-align: left; }
  .vp__highlights li { display: block; padding: 6px 0; border-bottom: 1px solid rgba(0,0,0,.06); font-size: 10px; color: var(--mid); letter-spacing: .3px; }

  .vp__contact { position: absolute; bottom: 0; left: 0; right: 0; height: 52px; background: linear-gradient(90deg, var(--smoke), #222228); display: flex; align-items: center; justify-content: space-between; padding: 0 36px; z-index: 10; }
  .vp__contact-item { display: inline-block; margin-right: 20px; }
  .vp__contact-dot { width: 6px; height: 6px; border-radius: 50%; background: var(--accent); display: inline-block; margin-right: 5px; }
  .vp__contact-text { color: var(--ghost); font-size: 9px; letter-spacing: 1px; }

  .vp__exclusivity { background: #fffcf5; border: 1px solid var(--accent-lt); border-radius: 8px; padding: 15px; margin-bottom: 10px; border-left: 4px solid var(--accent); }
  .vp__exclusivity-title { font-size: 10px; text-transform: uppercase; letter-spacing: 2px; color: var(--accent-dk); margin-bottom: 5px; font-weight: bold; }
  .vp__exclusivity-text { font-size: 11.5px; line-height: 1.5; color: #555; font-style: italic; }

CSS;

$html = <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8" />
<title>Catálogo Covel</title>
<style>
{$css}
</style>
</head>
<body>

<!-- PAGE 1: COVER -->
<div class="cover">
  <div class="cover__stripe"></div>
  <div class="cover__stripe cover__stripe--2"></div>
  <div class="cover__stripe cover__stripe--3"></div>
  <div class="cover__circle"></div>
  <div class="cover__circle cover__circle--2"></div>
  <div class="cover__circle cover__circle--3"></div>
  <div class="cover__poly"></div>

  <div class="cover__content">
    <div class="cover__logo-area">
      <div class="cover__logo-badge">CV</div>
      <div>
        <div class="cover__logo-text">Covel Veículos</div>
        <div class="cover__logo-sub">40 anos de mercado</div>
      </div>
    </div>

    <div class="cover__year-tag">Catálogo 2026</div>

    <div>
      <h1 class="cover__title">Seminovos<br><em>Selecionados</em></h1>
      <div class="cover__divider"></div>
      <p class="cover__subtitle">
        Mais de 12 mil veículos vendidos.<br>
        Revisão completa · Garantia até 2 anos · Procedência garantida.<br>
        <br>
        Especialmente para: <strong>{$userName}</strong>
      </p>
    </div>

    <div class="cover__footer">
      <div class="cover__footer-line">Encantado – Rio Grande do Sul</div>
      <div class="cover__footer-line" style="color: var(--mid); margin-top:3px;">Rua Júlio de Castilhos, 1795</div>
    </div>
  </div>
</div>

<!-- PAGE 2: VEHICLE DETAILS -->
<div class="vehicle-page">

  <div class="vp__header">
    <div class="vp__header-brand">Covel Veículos — Seminovos</div>
    <div class="vp__header-id">#{$vehicleId}</div>
  </div>

  <div class="vp__hero">
    <img class="vp__hero-img" src="{$img1}" />
  </div>

  <div class="vp__owner-badge">Único Dono</div>
  <div class="vp__plate">Final {$v['plate']}</div>

  <div class="vp__accent-bar"></div>

  <div class="vp__body">

    <!-- LEFT -->
    <div class="vp__left">
      <div class="vp__make">{$v['make']}</div>
      <div class="vp__model">{$v['model']}</div>
      <div class="vp__trim">{$trimLine}</div>
      <div class="vp__year-badge">{$yearDisplay}</div>

      <table class="vp__specs-table">
        <tr>
            <td>
                <span class="vp__spec-label">Quilômetros</span>
                <span class="vp__spec-value">{$v['km']}</span>
            </td>
            <td>
                <span class="vp__spec-label">Motor</span>
                <span class="vp__spec-value">{$v['fuel']}</span>
            </td>
        </tr>
        <tr>
            <td>
                <span class="vp__spec-label">Combustível</span>
                <span class="vp__spec-value">{$v['fuel']}</span>
            </td>
            <td>
                <span class="vp__spec-label">Câmbio</span>
                <span class="vp__spec-value">{$v['gear']}</span>
            </td>
        </tr>
        <tr>
            <td>
                <span class="vp__spec-label">Cor</span>
                <span class="vp__spec-value">{$v['color']}</span>
            </td>
            <td>
                <span class="vp__spec-label">Portas</span>
                <span class="vp__spec-value">{$v['doors']} Portas</span>
            </td>
        </tr>
        <tr>
            <td>
                <span class="vp__spec-label">Garantia</span>
                <span class="vp__spec-value" style="color: #27ae60;">Até 2 anos</span>
            </td>
            <td>
                <span class="vp__spec-label">Procedência</span>
                <span class="vp__spec-value" style="color: #27ae60;">Aprovada</span>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding-top:10px;">
                <div class="vp__exclusivity">
                    <div class="vp__exclusivity-title">Catálogo Exclusivo para {$userName}</div>
                    <div class="vp__exclusivity-text">"{$ai['welcome_message']}"</div>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding-top:10px;">
                <span class="vp__spec-label">Descrição do Especialista</span>
                <div style="font-size:11px; color:#333; line-height:1.5; margin-top:5px; text-align: justify;">
                   "{$ai['sales_copy']}"
                </div>
            </td>
        </tr>
      </table>
    </div>

    <!-- RIGHT -->
    <div class="vp__right">
      <div class="vp__price-box">
        <div class="vp__price-label">Valor à Vista</div>
        <div class="vp__price"><span>R$</span> {$v['price']}</div>
        <div class="vp__price-fipe">FIPE aprox: <strong>{$v['fipe']}</strong></div>
      </div>

      <ul class="vp__highlights">
        {$highlightsList}
      </ul>
    </div>
  </div>

  <div class="vp__contact">
    <div class="vp__contact-item">
      <div class="vp__contact-dot"></div>
      <span class="vp__contact-text">(51) 98167-0695</span>
    </div>
    <div class="vp__contact-item">
      <div class="vp__contact-dot"></div>
      <span class="vp__contact-text">Rua Júlio de Castilhos, 1795</span>
    </div>
    <div class="vp__contact-item">
      <div class="vp__contact-dot"></div>
      <span class="vp__contact-text">covel.com.br</span>
    </div>
  </div>
</div>

<!-- GALLERY PAGES -->
{$galleryHtml}

</body>
</html>
HTML;

// ==================== GENERATE PDF (PUPPETEER) ====================

// 1. Save HTML to temp file
$tmpDir = __DIR__ . '/tmp_gen';
if (!is_dir($tmpDir)) mkdir($tmpDir, 0777, true);

$uniqueId = $input['uniqueId'] ?? uniqid('lp_');
$htmlFile = "$tmpDir/{$uniqueId}.html";
$pdfFile = "$tmpDir/{$uniqueId}.pdf";

// Corrigir caminhos de imagens locais para file:/// se necessário no Puppeteer
// Mas como já estamos usando base64 ou URLs absolutas, deve funcionar.
file_put_contents($htmlFile, $html);

// 2. Call Node script
// Note: Estamos assumindo que 'node' e 'npm' estão no PATH do usuário que roda o PHP
$nodeScript = __DIR__ . '/render_pdf.js'; // Arquivo movido para o mesmo dir
$cmd = "node " . escapeshellarg($nodeScript) . " " . escapeshellarg($htmlFile) . " " . escapeshellarg($pdfFile) . " 2>&1";

exec($cmd, $output, $returnVar);

// 3. Output or Error
if ($returnVar === 0 && file_exists($pdfFile)) {
    // Success
    header("Content-Type: application/pdf");
    header("Content-Disposition: attachment; filename=catalogo_{$vehicleId}.pdf");
    header("Content-Length: " . filesize($pdfFile));
    readfile($pdfFile);
    
    // Cleanup
    // unlink($htmlFile); 
    // unlink($pdfFile);
} else {
    // Error
    throw new Exception("Puppeteer Failed: " . implode("\n", $output));
}

} catch (Exception $e) {
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
}
exit;
