<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Covel PDF Generator - Teste</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
        }
        .container {
            background: white;
            padding: 50px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            text-align: center;
            max-width: 500px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        p {
            color: #666;
            margin-bottom: 30px;
        }
        button {
            background: linear-gradient(135deg, #0044cc, #00c6ff);
            color: white;
            border: none;
            padding: 18px 40px;
            font-size: 16px;
            font-weight: bold;
            border-radius: 50px;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(0,68,204,0.4);
            transition: all 0.3s ease;
        }
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,68,204,0.6);
        }
        button:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
        }
        .status {
            margin-top: 20px;
            padding: 15px;
            background: #f0f0f0;
            border-radius: 8px;
            font-size: 14px;
            color: #555;
        }
        .status.loading { background: #fff3cd; color: #856404; }
        .status.success { background: #d4edda; color: #155724; }
        .status.error { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>

<div class="container">
    <h1>🚗 Gerador de Catálogo PDF</h1>
    <p>Teste o fluxo completo:<br>XML → IA → Puppeteer → Download</p>
    
    <div style="margin-bottom: 20px;">
        <input type="text" id="vehicleId" placeholder="ID do Veículo" value="7721357" 
               style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 14px; margin-bottom: 10px;">
        <input type="text" id="clientName" placeholder="Nome do Cliente" value="Augusto Teste" 
               style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 14px;">
    </div>
    
    <button id="btnGerar" onclick="gerarPDF()">
        📄 Gerar Catálogo de Teste
    </button>
    
    <div id="status" class="status" style="display:none"></div>
    
    <div style="margin-top: 30px; font-size: 12px; color: #999;">
        <strong>IDs disponíveis para teste:</strong><br>
        7721357 (Ford Territory) • 7700601 • 7645348
    </div>
</div>

<script>
async function gerarPDF() {
    const btn = document.getElementById('btnGerar');
    const status = document.getElementById('status');
    const vehicleId = document.getElementById('vehicleId').value.trim();
    const clientName = document.getElementById('clientName').value.trim();
    
    if (!vehicleId) {
        alert('Por favor, insira o ID do veículo');
        return;
    }
    
    btn.disabled = true;
    btn.textContent = '⏳ Gerando PDF...';
    status.style.display = 'block';
    status.className = 'status loading';
    status.textContent = 'Processando... Aguarde até 15 segundos';
    
    try {
        const response = await fetch('generate_lp.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                id: vehicleId,
                user_name: clientName || 'Cliente VIP'
            })
        });
        
        if (!response.ok) {
            const errorText = await response.text();
            throw new Error(errorText || 'Erro no servidor');
        }
        
        // Download do PDF
        const blob = await response.blob();
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'catalogo_teste.pdf';
        document.body.appendChild(a);
        a.click();
        window.URL.revokeObjectURL(url);
        a.remove();
        
        status.className = 'status success';
        status.textContent = '✅ PDF gerado com sucesso! Download iniciado.';
        
    } catch (error) {
        status.className = 'status error';
        status.textContent = '❌ Erro: ' + error.message;
        console.error(error);
    } finally {
        btn.disabled = false;
        btn.textContent = '📄 Gerar Catálogo de Teste';
    }
}
</script>

</body>
</html>
