/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * THIS FILE IS AUTOGENERATED by cddlconv 0.1.7.
 * Run `node tools/generate-bidi-types.mjs` to regenerate.
 * @see https://github.com/w3c/webdriver-bidi/blob/master/index.bs
 */
import z from 'zod';
export declare const UserAgentClientHintsCommandSchema: z.ZodLazy<z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"emulation.setClientHintsOverride">;
    params: z.ZodObject<{
        clientHints: z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            brands: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                brand: z.ZodString;
                version: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                brand: string;
                version: string;
            }, {
                brand: string;
                version: string;
            }>>, "many">>;
            fullVersionList: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                brand: z.ZodString;
                version: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                brand: string;
                version: string;
            }, {
                brand: string;
                version: string;
            }>>, "many">>;
            platform: z.ZodOptional<z.ZodString>;
            platformVersion: z.ZodOptional<z.ZodString>;
            architecture: z.ZodOptional<z.ZodString>;
            model: z.ZodOptional<z.ZodString>;
            mobile: z.ZodOptional<z.ZodBoolean>;
            bitness: z.ZodOptional<z.ZodString>;
            wow64: z.ZodOptional<z.ZodBoolean>;
            formFactors: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mobile?: boolean | undefined;
            brands?: {
                brand: string;
                version: string;
            }[] | undefined;
            fullVersionList?: {
                brand: string;
                version: string;
            }[] | undefined;
            platform?: string | undefined;
            platformVersion?: string | undefined;
            architecture?: string | undefined;
            model?: string | undefined;
            bitness?: string | undefined;
            wow64?: boolean | undefined;
            formFactors?: string[] | undefined;
        }, {
            mobile?: boolean | undefined;
            brands?: {
                brand: string;
                version: string;
            }[] | undefined;
            fullVersionList?: {
                brand: string;
                version: string;
            }[] | undefined;
            platform?: string | undefined;
            platformVersion?: string | undefined;
            architecture?: string | undefined;
            model?: string | undefined;
            bitness?: string | undefined;
            wow64?: boolean | undefined;
            formFactors?: string[] | undefined;
        }>>, z.ZodNull]>;
        contexts: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        userContexts: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        clientHints: {
            mobile?: boolean | undefined;
            brands?: {
                brand: string;
                version: string;
            }[] | undefined;
            fullVersionList?: {
                brand: string;
                version: string;
            }[] | undefined;
            platform?: string | undefined;
            platformVersion?: string | undefined;
            architecture?: string | undefined;
            model?: string | undefined;
            bitness?: string | undefined;
            wow64?: boolean | undefined;
            formFactors?: string[] | undefined;
        } | null;
        userContexts?: string[] | undefined;
        contexts?: string[] | undefined;
    }, {
        clientHints: {
            mobile?: boolean | undefined;
            brands?: {
                brand: string;
                version: string;
            }[] | undefined;
            fullVersionList?: {
                brand: string;
                version: string;
            }[] | undefined;
            platform?: string | undefined;
            platformVersion?: string | undefined;
            architecture?: string | undefined;
            model?: string | undefined;
            bitness?: string | undefined;
            wow64?: boolean | undefined;
            formFactors?: string[] | undefined;
        } | null;
        userContexts?: string[] | undefined;
        contexts?: string[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        clientHints: {
            mobile?: boolean | undefined;
            brands?: {
                brand: string;
                version: string;
            }[] | undefined;
            fullVersionList?: {
                brand: string;
                version: string;
            }[] | undefined;
            platform?: string | undefined;
            platformVersion?: string | undefined;
            architecture?: string | undefined;
            model?: string | undefined;
            bitness?: string | undefined;
            wow64?: boolean | undefined;
            formFactors?: string[] | undefined;
        } | null;
        userContexts?: string[] | undefined;
        contexts?: string[] | undefined;
    };
    method: "emulation.setClientHintsOverride";
}, {
    params: {
        clientHints: {
            mobile?: boolean | undefined;
            brands?: {
                brand: string;
                version: string;
            }[] | undefined;
            fullVersionList?: {
                brand: string;
                version: string;
            }[] | undefined;
            platform?: string | undefined;
            platformVersion?: string | undefined;
            architecture?: string | undefined;
            model?: string | undefined;
            bitness?: string | undefined;
            wow64?: boolean | undefined;
            formFactors?: string[] | undefined;
        } | null;
        userContexts?: string[] | undefined;
        contexts?: string[] | undefined;
    };
    method: "emulation.setClientHintsOverride";
}>>>;
export declare namespace Emulation {
    const SetClientHintsOverrideCommandSchema: z.ZodLazy<z.ZodObject<{
        method: z.ZodLiteral<"emulation.setClientHintsOverride">;
        params: z.ZodObject<{
            clientHints: z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                brands: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                    brand: z.ZodString;
                    version: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    brand: string;
                    version: string;
                }, {
                    brand: string;
                    version: string;
                }>>, "many">>;
                fullVersionList: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                    brand: z.ZodString;
                    version: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    brand: string;
                    version: string;
                }, {
                    brand: string;
                    version: string;
                }>>, "many">>;
                platform: z.ZodOptional<z.ZodString>;
                platformVersion: z.ZodOptional<z.ZodString>;
                architecture: z.ZodOptional<z.ZodString>;
                model: z.ZodOptional<z.ZodString>;
                mobile: z.ZodOptional<z.ZodBoolean>;
                bitness: z.ZodOptional<z.ZodString>;
                wow64: z.ZodOptional<z.ZodBoolean>;
                formFactors: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mobile?: boolean | undefined;
                brands?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                fullVersionList?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                platform?: string | undefined;
                platformVersion?: string | undefined;
                architecture?: string | undefined;
                model?: string | undefined;
                bitness?: string | undefined;
                wow64?: boolean | undefined;
                formFactors?: string[] | undefined;
            }, {
                mobile?: boolean | undefined;
                brands?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                fullVersionList?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                platform?: string | undefined;
                platformVersion?: string | undefined;
                architecture?: string | undefined;
                model?: string | undefined;
                bitness?: string | undefined;
                wow64?: boolean | undefined;
                formFactors?: string[] | undefined;
            }>>, z.ZodNull]>;
            contexts: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            userContexts: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            clientHints: {
                mobile?: boolean | undefined;
                brands?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                fullVersionList?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                platform?: string | undefined;
                platformVersion?: string | undefined;
                architecture?: string | undefined;
                model?: string | undefined;
                bitness?: string | undefined;
                wow64?: boolean | undefined;
                formFactors?: string[] | undefined;
            } | null;
            userContexts?: string[] | undefined;
            contexts?: string[] | undefined;
        }, {
            clientHints: {
                mobile?: boolean | undefined;
                brands?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                fullVersionList?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                platform?: string | undefined;
                platformVersion?: string | undefined;
                architecture?: string | undefined;
                model?: string | undefined;
                bitness?: string | undefined;
                wow64?: boolean | undefined;
                formFactors?: string[] | undefined;
            } | null;
            userContexts?: string[] | undefined;
            contexts?: string[] | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        params: {
            clientHints: {
                mobile?: boolean | undefined;
                brands?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                fullVersionList?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                platform?: string | undefined;
                platformVersion?: string | undefined;
                architecture?: string | undefined;
                model?: string | undefined;
                bitness?: string | undefined;
                wow64?: boolean | undefined;
                formFactors?: string[] | undefined;
            } | null;
            userContexts?: string[] | undefined;
            contexts?: string[] | undefined;
        };
        method: "emulation.setClientHintsOverride";
    }, {
        params: {
            clientHints: {
                mobile?: boolean | undefined;
                brands?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                fullVersionList?: {
                    brand: string;
                    version: string;
                }[] | undefined;
                platform?: string | undefined;
                platformVersion?: string | undefined;
                architecture?: string | undefined;
                model?: string | undefined;
                bitness?: string | undefined;
                wow64?: boolean | undefined;
                formFactors?: string[] | undefined;
            } | null;
            userContexts?: string[] | undefined;
            contexts?: string[] | undefined;
        };
        method: "emulation.setClientHintsOverride";
    }>>;
}
export declare namespace Emulation {
    const ClientHintsMetadataSchema: z.ZodLazy<z.ZodObject<{
        brands: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            brand: z.ZodString;
            version: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            brand: string;
            version: string;
        }, {
            brand: string;
            version: string;
        }>>, "many">>;
        fullVersionList: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            brand: z.ZodString;
            version: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            brand: string;
            version: string;
        }, {
            brand: string;
            version: string;
        }>>, "many">>;
        platform: z.ZodOptional<z.ZodString>;
        platformVersion: z.ZodOptional<z.ZodString>;
        architecture: z.ZodOptional<z.ZodString>;
        model: z.ZodOptional<z.ZodString>;
        mobile: z.ZodOptional<z.ZodBoolean>;
        bitness: z.ZodOptional<z.ZodString>;
        wow64: z.ZodOptional<z.ZodBoolean>;
        formFactors: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mobile?: boolean | undefined;
        brands?: {
            brand: string;
            version: string;
        }[] | undefined;
        fullVersionList?: {
            brand: string;
            version: string;
        }[] | undefined;
        platform?: string | undefined;
        platformVersion?: string | undefined;
        architecture?: string | undefined;
        model?: string | undefined;
        bitness?: string | undefined;
        wow64?: boolean | undefined;
        formFactors?: string[] | undefined;
    }, {
        mobile?: boolean | undefined;
        brands?: {
            brand: string;
            version: string;
        }[] | undefined;
        fullVersionList?: {
            brand: string;
            version: string;
        }[] | undefined;
        platform?: string | undefined;
        platformVersion?: string | undefined;
        architecture?: string | undefined;
        model?: string | undefined;
        bitness?: string | undefined;
        wow64?: boolean | undefined;
        formFactors?: string[] | undefined;
    }>>;
}
export declare namespace Emulation {
    const BrandVersionSchema: z.ZodLazy<z.ZodObject<{
        brand: z.ZodString;
        version: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        brand: string;
        version: string;
    }, {
        brand: string;
        version: string;
    }>>;
}
export declare namespace Emulation {
    const SetClientHintsOverrideResultSchema: z.ZodLazy<z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>>;
}
