# Covel PDF IA Generator 🚗📄

Sistema inteligente para geração de catálogos premium de veículos em PDF, utilizando IA para copywriting personalizado e Puppeteer para renderização de alta qualidade.

## 🚀 Funcionalidades

- **Personalização Dinâmica**: Gera catálogos exclusivos com o nome do cliente.
- **Copywriting com IA**: Integração com OpenAI ou Ollama (local) para criar textos persuasivos.
- **Layout Premium**: Design sofisticado com capas exclusivas e galeria de fotos.
- **Resiliência Total**: Sistema de polling assíncrono para evitar timeouts em conexões lentas ou túneis (Serveo/Ngrok).
- **Integração via Console**: Script JS pronto para ser injetado em qualquer site de inventário.

## 🛠️ Tecnologias

- **Backend**: PHP 8.2 (Docker)
- **PDF Engine**: Puppeteer (Node.js) via Google Chrome Headless
- **AI**: OpenAI (GPT-4o) / Ollama (Llama 3.2:1b)
- **Frontend**: Vanilla JS (Injeção via Console)

## 📦 Instalação

### 1. Requisitos:
- Docker e Docker-Compose
- Node.js e NPM (para renderização local se não usar Docker)
- Ollama (opcional, para IA local)

### 2. Configuração:
Clone o repositório e inicie o ambiente:

```bash
docker-compose up -d
```

### 3. Instale as dependências do Node (dentro da pasta src/php):
```bash
cd src/php
npm install
```

## 🚀 Como usar

1. **Acesse o Painel de Teste**:
   Abra `http://localhost:8080/index.php`.

2. **Gere pela URL de Produção**:
   Configure o `TUNNEL_URL` no arquivo `src/js/covel-pdf-ia-generator.js` e injete o código no console do navegador do site da concessionária.

## 📄 Estratégia de Arquivos

- `generate_lp.php`: Processa o XML, consulta a IA e dispara a renderização.
- `check_pdf.php`: Verifica se o PDF está pronto (Polling).
- `download_pdf.php`: Entrega o arquivo e limpa o sistema.
- `ai_service.php`: Abstração de provedores de IA.

## ⚖️ Licença
Este projeto é de uso exclusivo para a Covel Veículos.
