<?php
/**
 * Verifica se um arquivo PDF específico já foi gerado
 */
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: *");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') exit(0);

$fileId = $_GET['fileId'] ?? '';
if (!$fileId || !preg_match('/^[a-zA-Z0-9_]+$/', $fileId)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid File ID']);
    exit;
}

$tmpDir = __DIR__ . '/tmp_gen';
$pdfFile = "$tmpDir/{$fileId}.pdf";

header('Content-Type: application/json');

if (file_exists($pdfFile)) {
    // Se o arquivo existe, verifica se o tamanho não está mudando (ainda sendo escrito)
    $size1 = filesize($pdfFile);
    usleep(100000); // 100ms
    clearstatcache();
    $size2 = filesize($pdfFile);
    
    if ($size1 === $size2 && $size1 > 0) {
        echo json_encode(['ready' => true, 'url' => 'download_pdf.php?fileId=' . $fileId]);
    } else {
        echo json_encode(['ready' => false, 'status' => 'writing']);
    }
} else {
    echo json_encode(['ready' => false, 'status' => 'waiting']);
}
